const audio = document.getElementById("ac-audio");
const playBtn = document.getElementById("ac-play");
const songEl = document.getElementById("ac-song");
const djEl = document.getElementById("ac-dj");
const listenersEl = document.getElementById("ac-listeners");
const volumeSlider = document.getElementById("ac-volume");

audio.src = ACDATA.stream;
audio.volume = 0.8;

if (ACDATA.autoplay) {
  window.addEventListener("load", () => {
    audio.play().catch(() => {});
  });
}

playBtn.onclick = async () => {
  audio.muted = false;
  if (audio.paused) {
    await audio.play();
    playBtn.textContent = "⏸ Tauko";
  } else {
    audio.pause();
    playBtn.textContent = "▶ Kuuntele";
  }
};

volumeSlider.addEventListener("input", () => {
  audio.volume = volumeSlider.value;
});

async function updateNowPlaying() {
  try {
    const r = await fetch(ACDATA.api);
    const d = await r.json();
    const song = d.now_playing.song;

    // Päivitä vain biisin nimi
    songEl.textContent = (song.artist || "") + " – " + (song.title || "");

    djEl.textContent = d.live.is_live ? "🔴 LIVE DJ" : "";
    listenersEl.textContent = "👥 " + d.listeners.current;
  } catch(e) {
    console.error("AzuraCast API error", e);
  }
}

updateNowPlaying();
setInterval(updateNowPlaying, 10000);
